# Bakery & Cakes Store Theme

A warm, food-oriented theme designed specifically for bakeries, cake shops, and pastry stores.

## Design Features

### Color Palette
- **Primary**: Warm oranges and ambers (#f97316, #f59e0b)
- **Secondary**: Rich browns and golds (#92400e, #d97706)
- **Accent**: Soft yellows and creams (#fef3c7, #fffbeb)
- **Background**: Gradient from orange to yellow tones

### Typography
- **Headings**: Serif fonts for elegance and traditional feel
- **Body**: Sans-serif for readability
- **Emphasis**: Food emojis and decorative elements

### Visual Elements
- Food emojis throughout the design (🍰, 🧁, 🥐, 🍪, etc.)
- Gradient backgrounds with warm tones
- Rounded corners and soft shadows
- Decorative dividers with food icons
- Wave patterns for visual interest

## Components

### Header
- Bakery-themed logo placeholder with cupcake emoji
- Warm color scheme with orange/amber gradients
- Mobile-responsive navigation
- Search functionality with bakery-specific placeholder

### Hero Section
- Gradient background with scattered food emojis
- Store information cards (location, hours, contact)
- Welcoming message with bakery tagline
- Wave pattern at bottom for visual flow

### Category Tabs
- Food emoji icons for each category
- Horizontal scrolling on mobile
- Sticky navigation for easy access
- Smooth scrolling to category sections

### Product Grid
- Card-based layout with hover effects
- Star ratings for products
- Sale badges and out-of-stock overlays
- Warm color scheme for buttons and accents

### Footer
- Rich dark background with warm tones
- Comprehensive store information
- Opening hours and contact details
- Social media links
- Bakery-specific messaging

## Responsive Design

- **Mobile First**: Optimized for WhatsApp in-app browser
- **Tablet**: Improved grid layouts and spacing
- **Desktop**: Full-width layouts with enhanced visuals

## Unique Features

- Category-specific food emojis
- Bakery-themed messaging and copy
- Warm, inviting color palette
- Traditional bakery aesthetic
- Food-focused visual elements

## Usage

This theme reuses all existing functionality from the base theme system while providing a completely unique visual experience tailored for bakery businesses.