import { AutoScrollerOptions } from './auto-scroller-options-types';

// default autoScroll configuration options
export const defaultAutoScrollerOptions: AutoScrollerOptions = {
  startFromPercentage: 0.25,
  maxScrollAtPercentage: 0.05,
  maxPixelScroll: 28,
  ease: (percentage: number): number => percentage ** 2,
  durationDampening: {
    stopDampeningAt: 1200,
    accelerateAt: 360,
  },
  disabled: false,
};
