<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRegistrationEnabled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // If registration is disabled, redirect to login with error message
        if (!isRegistrationEnabled()) {
            return redirect()->route('login')->with('error', __('User registration is currently disabled.'));
        }

        return $next($request);
    }
}